#!/usr/bin/env python3
import afmtogmx as afm
import os
import sys
from subprocess import check_output

# Generate gromacs input files
off = afm.ReadOFF(off_loc = "intra.off")
nonbonded_tabpot = off.gen_nonbonded_tabpot()
off.write_nonbonded_tabpot(nonbonded_tabpot=nonbonded_tabpot, prefix='table')
off.gen_nonbonded_topology(template_file = 'template.top', write_to = 'temp_nonbonded.top')
off.gen_bonded_topology(template_file = 'temp_nonbonded.top', write_to='topol.top')



### Create symbolic links of tables so gromacs doesn't complain
os.chdir('tabpot')
tables = check_output(["ls -1 *_*xvg"], shell=True).decode("utf-8").split()
tables = [i for i in tables if "_b0" not in i]

def prefix_at1_at2(string):
    prefix, at1, at2_xvg = string.split("_")
    at2 = at2_xvg[:-4]
    return prefix, at1, at2

for table in tables:
    prefix, at1, at2 = prefix_at1_at2(table)
    os.system(f"ln -s {table} {prefix}_{at2}_{at1}.xvg")
