#!/usr/bin/env python3
import os
import sys
from subprocess import check_output
from pathlib import Path

lines_per_pxyz = 92
gro_files = check_output("ls -1 01_grofiles/ | grep 'final' | grep '\\.gro'", shell=True).decode("utf-8").strip().split()  # list all gro files

### Begin selecting configurations
# Define function to generate unnamed properly formatted pxyz file; if while loop continues forever, can increase mark_boundary 5 -1 -1 to mark_boundary {6,7} -1 -1 or something like that
def gen_pxyz(grofile):
    print(grofile)
    os.system(f"gro2pxyz 01_grofiles/{grofile} | mark_byname TAR -1 > k; mark_boundary 5 -1 -1 k; pxyz_sort k | grep -v TAR | xyz_fix_linenu > h.pxyz && rm k")
    os.system(f"markup_random -1 4 h.pxyz > k && mv k h.pxyz; mark_boundary 3 4 0 h.pxyz")
    os.system(f"markup_random 0 4 h.pxyz | markup_random 0 4 | markup_random 0 4 | markup_random 0 4 | markup_random 0 4 > k && mv k h.pxyz")
    os.system(f"pxyz_dropoff 3 h.pxyz > k && mv k h.pxyz")


# loop over gro files
for item in gro_files:
    numlines = 0
    # while loop here to ensure that each pxyz file has selected 5 molecules
    while numlines != lines_per_pxyz:
        gen_pxyz(item)
        numlines = int(check_output(f'wc -l h.pxyz', shell=True).decode("utf-8").strip().split()[0])
    filename = Path(item).stem
    os.system(f"mv h.pxyz 02_pxyz_files/{filename}.pxyz")


