#!/usr/bin/env python3
import os
import sys
from subprocess import check_output
from pathlib import Path

pxyz_files = check_output("ls -1 02_pxyz_files/*pxyz", shell=True).decode("utf-8").strip().split()

names = []

for item in pxyz_files:
    filename = os.path.basename(item)
    names.append(Path(filename).stem)

for pxyz_file, direc in zip(pxyz_files, names):
    os.system(f"chunk 2 9999 {pxyz_file} | ref_gen_step1_cord 04_ref_files/molinfo > 04_ref_files/{direc}.ref")

for direc in names:
    os.system(f"ref_upd_orca_grad 03_force_calculations/{direc}/MyMol.engrad 04_ref_files/{direc}.ref \
    | ref_upd_net | xyz_fix_linenu > h && mv h 04_ref_files/{direc}.ref")
