#!/bin/bash

targets=$(ls -d1 final*gro)

for item in $targets; do
    filename=$(echo "${item%.*}") # get name without extension
    mv $item ${filename}_temp.gro
    gmx_d insert-molecules -f ${filename}_temp.gro -ci insert_atom.gro -o ${filename}_hold.gro -nmol 1 -radius 0.01 -scale 0.1 && \
    echo "6 0" | gmx_d trjconv -f ${filename}_hold.gro -pbc mol -center -o ${filename}_centered.gro -s dummy.tpr -n index.ndx && \
    echo "0" | gmx_d trjconv -f ${filename}_centered.gro -o $item -pbc whole -s dummy.tpr  && \
    rm ${filename}_temp.gro ${filename}_hold.gro ${filename}_centered.gro
done
